/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MasterBiomancerEntersBattlefieldEffect
extends ReplacementEffectImpl {
    MasterBiomancerEntersBattlefieldEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "Each other creature you control enters the battlefield with a number of additional +1/+1 counters on it equal to {this}'s power and as a Mutant in addition to its other types";
    }

    private MasterBiomancerEntersBattlefieldEffect(MasterBiomancerEntersBattlefieldEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        return creature != null && creature.isControlledBy(source.getControllerId()) && creature.isCreature(game) && !event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent sourceCreature = game.getPermanent(source.getSourceId());
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (sourceCreature != null && creature != null) {
            int power = sourceCreature.getPower().getValue();
            if (power > 0) {
                creature.addCounters(CounterType.P1P1.createInstance(power), source.getControllerId(), source, game);
            }
            AddCardSubTypeTargetEffect effect = new AddCardSubTypeTargetEffect(SubType.MUTANT, Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), creature.getZoneChangeCounter(game) + 1));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return false;
    }

    public MasterBiomancerEntersBattlefieldEffect copy() {
        return new MasterBiomancerEntersBattlefieldEffect(this);
    }
}

