/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.CitizenGreenWhiteToken;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MasterOfCeremoniesChoiceEffect
extends OneShotEffect {
    MasterOfCeremoniesChoiceEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent chooses money, friends, or secrets. For each player who chose money, you and that player each create a Treasure token. For each player who chose friends, you and that player each create a 1/1 green and white Citizen creature token. For each player who chose secrets, you and that player each draw a card.";
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet<UUID> moneyChoosers = new HashSet<UUID>();
        HashSet<UUID> friendChoosers = new HashSet<UUID>();
        HashSet<UUID> secretsChoosers = new HashSet<UUID>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.getChoices().add("Money");
            choice.getChoices().add("Friends");
            choice.getChoices().add("Secrets");
            if (!opponent.choose(Outcome.Neutral, (Choice)choice, game)) continue;
            game.informPlayers(opponent.getLogName() + " chooses " + choice.getChoice());
            switch (choice.getChoice()) {
                case "Money": {
                    moneyChoosers.add(opponentId);
                    break;
                }
                case "Friends": {
                    friendChoosers.add(opponentId);
                    break;
                }
                case "Secrets": {
                    secretsChoosers.add(opponentId);
                }
            }
        }
        for (UUID opponentId : moneyChoosers) {
            TreasureToken treasureController = new TreasureToken();
            treasureController.putOntoBattlefield(1, game, source, controller.getId());
            TreasureToken treasureOpponent = new TreasureToken();
            treasureOpponent.putOntoBattlefield(1, game, source, opponentId);
        }
        game.processAction();
        for (UUID opponentId : friendChoosers) {
            CitizenGreenWhiteToken citizenOwner = new CitizenGreenWhiteToken();
            citizenOwner.putOntoBattlefield(1, game, source, controller.getId());
            CitizenGreenWhiteToken citizenOpponent = new CitizenGreenWhiteToken();
            citizenOpponent.putOntoBattlefield(1, game, source, opponentId);
        }
        game.processAction();
        for (UUID opponentId : secretsChoosers) {
            DrawCardTargetEffect drawEffectController = new DrawCardTargetEffect(1);
            drawEffectController.setTargetPointer((TargetPointer)new FixedTarget(controller.getId()));
            drawEffectController.apply(game, source);
            DrawCardTargetEffect drawEffectOpponent = new DrawCardTargetEffect(1);
            drawEffectOpponent.setTargetPointer((TargetPointer)new FixedTarget(opponentId));
            drawEffectOpponent.apply(game, source);
        }
        return true;
    }

    private MasterOfCeremoniesChoiceEffect(MasterOfCeremoniesChoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public MasterOfCeremoniesChoiceEffect copy() {
        return new MasterOfCeremoniesChoiceEffect(this);
    }
}

