/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class MasterOfPredicamentsEffect
extends OneShotEffect {
    MasterOfPredicamentsEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "choose a card in your hand. That player guesses whether the card's mana value is greater than 4. If the player guessed wrong, you may cast the card without paying its mana cost";
    }

    private MasterOfPredicamentsEffect(MasterOfPredicamentsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MasterOfPredicamentsEffect copy() {
        return new MasterOfPredicamentsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (!controller.getHand().isEmpty()) {
                boolean guessWrong;
                Card cardFromHand = null;
                if (controller.getHand().size() > 1) {
                    TargetCardInHand target = new TargetCardInHand(new FilterCard());
                    if (controller.choose(Outcome.PlayForFree, controller.getHand(), (TargetCard)target, source, game)) {
                        cardFromHand = game.getCard(target.getFirstTarget());
                    }
                } else {
                    cardFromHand = controller.getHand().getRandom(game);
                }
                if (cardFromHand == null) {
                    return false;
                }
                Player attackedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                if (attackedPlayer == null) {
                    return false;
                }
                if (attackedPlayer.chooseUse(Outcome.Detriment, "Is the chosen card's mana value greater than 4?", source, game)) {
                    game.informPlayers(attackedPlayer.getLogName() + " guessed that the chosen card's mana value is greater than 4");
                    guessWrong = cardFromHand.getManaValue() <= 4;
                } else {
                    game.informPlayers(attackedPlayer.getLogName() + " guessed that the chosen card's mana value is not greater than 4");
                    guessWrong = cardFromHand.getManaValue() > 4;
                }
                game.informPlayers(attackedPlayer.getLogName() + " guessed " + (guessWrong ? "wrong" : "right"));
                if (guessWrong && !cardFromHand.isLand(game) && controller.chooseUse(this.outcome, "Cast " + cardFromHand.getName() + " without paying its mana cost?", source, game)) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + cardFromHand.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(cardFromHand, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + cardFromHand.getId(), null);
                }
            }
            return true;
        }
        return false;
    }
}

