/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MasterOfTheWildHuntEffect
extends OneShotEffect {
    protected static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public MasterOfTheWildHuntEffect() {
        super(Outcome.Damage);
        this.staticText = "Tap all untapped Wolf creatures you control. Each Wolf tapped this way deals damage equal to its power to target creature. That creature deals damage equal to its power divided as its controller chooses among any number of those Wolves";
    }

    private MasterOfTheWildHuntEffect(MasterOfTheWildHuntEffect effect) {
        super((OneShotEffect)effect);
    }

    public MasterOfTheWildHuntEffect copy() {
        return new MasterOfTheWildHuntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> wolves = new ArrayList<Permanent>();
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        Player player = game.getPlayer(target.getControllerId());
        if (player == null) {
            return false;
        }
        if (game.getBattlefield().countAll((FilterPermanent)filter, source.getControllerId(), game) > 0) {
            for (Permanent permanent2 : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                permanent2.tap(source, game);
                target.damage(permanent2.getPower().getValue(), permanent2.getId(), source, game);
                wolves.add(permanent2);
            }
        }
        if (wolves.isEmpty()) {
            return true;
        }
        int totalDamage = target.getPower().getValue();
        ArrayList messages = new ArrayList();
        wolves.forEach(permanent -> {
            String info = String.format("%s, P/T: %d/%d", permanent.getLogName(), permanent.getPower().getValue(), permanent.getToughness().getValue());
            messages.add(info);
        });
        List damagesList = player.getMultiAmount(Outcome.Damage, messages, 0, totalDamage, totalDamage, MultiAmountType.DAMAGE, game);
        if (damagesList.size() == wolves.size()) {
            for (int i = 0; i < wolves.size(); ++i) {
                ((Permanent)wolves.get(i)).damage(((Integer)damagesList.get(i)).intValue(), target.getId(), source, game, false, true);
            }
        } else {
            throw new IllegalArgumentException("Wrong code usage: getMultiAmount must return same size");
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.WOLF.getPredicate());
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

