/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class MasterfulReplicationEffect
extends OneShotEffect {
    MasterfulReplicationEffect() {
        super(Outcome.Copy);
        this.staticText = "Choose target artifact you control. Each other artifact you control becomes a copy of that artifact until end of turn.";
    }

    private MasterfulReplicationEffect(MasterfulReplicationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MasterfulReplicationEffect copy() {
        return new MasterfulReplicationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent copyFromArtifact = game.getPermanent(source.getFirstTarget());
        if (copyFromArtifact == null) {
            return false;
        }
        for (Permanent copyToArtifact : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (!copyToArtifact.isArtifact(game) || copyToArtifact.getId().equals(copyFromArtifact.getId())) continue;
            game.copyPermanent(Duration.EndOfTurn, copyFromArtifact, copyToArtifact.getId(), source, (CopyApplier)new EmptyCopyApplier());
        }
        return true;
    }
}

