/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class MastersManufactoryWatcher
extends Watcher {
    private final Set<UUID> playerHadArtifactEnter = new HashSet<UUID>();
    private final Map<UUID, Set<MageObjectReference>> allEnteredThisTurn = new HashMap<UUID, Set<MageObjectReference>>();

    MastersManufactoryWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
            if (permanent.isArtifact(game)) {
                this.playerHadArtifactEnter.add(event.getPlayerId());
            }
            this.allEnteredThisTurn.computeIfAbsent(event.getPlayerId(), k -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        super.reset();
        this.playerHadArtifactEnter.clear();
        this.allEnteredThisTurn.clear();
    }

    boolean check(UUID playerId, MageObjectReference mor) {
        return this.playerHadArtifactEnter.contains(playerId) || this.allEnteredThisTurn.getOrDefault(playerId, Collections.emptySet()).contains(mor);
    }
}

