/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class MausoleumSecretsEffect
extends OneShotEffect {
    MausoleumSecretsEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Undergrowth</i> &mdash; Search your library for a black card with mana value less than or equal to the number of creature cards in your graveyard, reveal it, put it into your hand, then shuffle.";
    }

    private MausoleumSecretsEffect(MausoleumSecretsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MausoleumSecretsEffect copy() {
        return new MausoleumSecretsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int critterCount = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        FilterCard filter = new FilterCard("a black card with mana value less than or equal to " + critterCount);
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, critterCount + 1));
        return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true).apply(game, source);
    }
}

