/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.IxalanVampireToken;
import mage.game.permanent.token.Token;

class MavrenFeinDuskApostleTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("nontoken Vampires you control");

    public MavrenFeinDuskApostleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new IxalanVampireToken()), false);
        this.setTriggerPhrase("Whenever one or more nontoken Vampires you control attack, ");
    }

    private MavrenFeinDuskApostleTriggeredAbility(MavrenFeinDuskApostleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MavrenFeinDuskApostleTriggeredAbility copy() {
        return new MavrenFeinDuskApostleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        for (UUID creatureId : game.getCombat().getAttackers()) {
            Permanent creature = game.getPermanent(creatureId);
            if (creature == null || !filter.match((Object)creature, game) || !creature.isControlledBy(this.controllerId)) continue;
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.VAMPIRE.getPredicate());
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

