/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MayaelsAriaEffect
extends OneShotEffect {
    MayaelsAriaEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on each creature you control if you control a creature with power 5 or greater. Then you gain 10 life if you control a creature with power 10 or greater. Then you win the game if you control a creature with power 20 or greater";
    }

    private MayaelsAriaEffect(MayaelsAriaEffect effect) {
        super((OneShotEffect)effect);
    }

    public MayaelsAriaEffect copy() {
        return new MayaelsAriaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 4));
        if (game.getBattlefield().countAll((FilterPermanent)filter, controller.getId(), game) > 0) {
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
                creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            }
        }
        game.processAction();
        filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 9));
        if (game.getBattlefield().countAll((FilterPermanent)filter, controller.getId(), game) > 0) {
            controller.gainLife(10, game, source);
        }
        filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 19));
        if (game.getBattlefield().countAll((FilterPermanent)filter, controller.getId(), game) > 0) {
            controller.won(game);
        }
        return true;
    }
}

