/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.StateTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MazemindTomeTriggeredAbility
extends StateTriggeredAbility {
    MazemindTomeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new GainLifeEffect(4), (Cost)new ExileSourceCost(), null, false));
    }

    private MazemindTomeTriggeredAbility(MazemindTomeTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public MazemindTomeTriggeredAbility copy() {
        return new MazemindTomeTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.PAGE) >= 4;
    }

    public String getRule() {
        return "When there are four or more page counters on {this}, exile it. If you do, you gain 4 life.";
    }
}

