/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.common.AttacksAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.SetTargetPointer;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.EnchantedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MazzyAttackTriggeredAbility
extends AttacksAllTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("enchanted creature");

    MazzyAttackTriggeredAbility() {
        super((Effect)new BoostTargetEffect(2, 0, Duration.EndOfTurn).setText("it gets +2/+0 and gains trample until end of turn"), false, filter, SetTargetPointer.PERMANENT, false);
        this.addEffect((Effect)new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn));
    }

    private MazzyAttackTriggeredAbility(MazzyAttackTriggeredAbility effect) {
        super((AttacksAllTriggeredAbility)effect);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            Player defender = game.getPlayer(event.getTargetId());
            if (defender == null) {
                return false;
            }
            Set opponents = game.getOpponents(this.getControllerId());
            if (opponents != null && opponents.contains(defender.getId())) {
                this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever an enchanted creature attacks one of your opponents, it gets +2/+0 and gains trample until end of turn.";
    }

    public MazzyAttackTriggeredAbility copy() {
        return new MazzyAttackTriggeredAbility(this);
    }

    static {
        filter.add((Predicate)EnchantedPredicate.instance);
    }
}

