/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.m.MeanderingTowershellReturnEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MeanderingTowershellEffect
extends OneShotEffect {
    MeanderingTowershellEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile it. Return it to the battlefield under your control tapped and attacking at the beginning of the declare attackers step on your next turn";
    }

    private MeanderingTowershellEffect(MeanderingTowershellEffect effect) {
        super((OneShotEffect)effect);
    }

    public MeanderingTowershellEffect copy() {
        return new MeanderingTowershellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            controller.moveCardToExileWithInfo((Card)sourcePermanent, null, "", source, game, Zone.BATTLEFIELD, true);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfStepOfYourNextTurnDelayedTriggeredAbility((Effect)new MeanderingTowershellReturnEffect(), GameEvent.EventType.DECLARE_ATTACKERS_STEP_PRE), source);
            return true;
        }
        return false;
    }
}

