/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashMap;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.functions.CopyTokenFunction;

class MechanizedProductionEffect
extends OneShotEffect {
    MechanizedProductionEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of enchanted artifact. Then if you control eight or more artifacts with the same name as one another, you win the game";
    }

    private MechanizedProductionEffect(MechanizedProductionEffect effect) {
        super((OneShotEffect)effect);
    }

    public MechanizedProductionEffect copy() {
        return new MechanizedProductionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject != null && sourceObject.getAttachedTo() != null) {
            Permanent enchantedArtifact = game.getPermanentOrLKIBattlefield(sourceObject.getAttachedTo());
            if (enchantedArtifact != null) {
                Token token = CopyTokenFunction.createTokenCopy((Card)enchantedArtifact, (Game)game);
                token.putOntoBattlefield(1, game, source, source.getControllerId());
            }
            HashMap<String, Integer> countNames = new HashMap<String, Integer>();
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterArtifactPermanent(), source.getControllerId(), game)) {
                int counter = countNames.getOrDefault(permanent.getName(), 0);
                countNames.put(permanent.getName(), counter + 1);
            }
            for (Map.Entry entry : countNames.entrySet()) {
                Player controller;
                if ((Integer)entry.getValue() <= 7 || (controller = game.getPlayer(source.getControllerId())) == null) continue;
                game.informPlayers(controller.getLogName() + " controls eight or more artifacts with the same name as one another (" + (String)entry.getKey() + ").");
                controller.won(game);
                return true;
            }
            return true;
        }
        return false;
    }
}

