/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class MedomaisProphecyDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final String spellName;

    MedomaisProphecyDelayedTriggeredAbility(String spellName) {
        super((Effect)new DrawCardSourceControllerEffect(2), Duration.EndOfTurn, true, false);
        this.spellName = spellName;
    }

    private MedomaisProphecyDelayedTriggeredAbility(MedomaisProphecyDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.spellName = ability.spellName;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && this.spellName.equals(spell.getName());
    }

    public MedomaisProphecyDelayedTriggeredAbility copy() {
        return new MedomaisProphecyDelayedTriggeredAbility(this);
    }
}

