/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MelekIzzetParagonTriggeredAbility
extends TriggeredAbilityImpl {
    public MelekIzzetParagonTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CopyTargetStackObjectEffect(), false);
    }

    private MelekIzzetParagonTriggeredAbility(MelekIzzetParagonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MelekIzzetParagonTriggeredAbility copy() {
        return new MelekIzzetParagonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getZone() == Zone.LIBRARY && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isOwnedBy(super.getControllerId()) && (spell.isInstant(game) || spell.isSorcery(game))) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell from your library, copy it. You may choose new targets for the copy.";
    }
}

