/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetOpponent;

class MemoriesReturningEffect
extends OneShotEffect {
    MemoriesReturningEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top five cards of your library. Put one of them into your hand. Then choose an opponent. They put one on the bottom of your library. Then you put one into your hand. Then they put one on the bottom of your library. Put the other into your hand";
    }

    private MemoriesReturningEffect(MemoriesReturningEffect effect) {
        super((OneShotEffect)effect);
    }

    public MemoriesReturningEffect copy() {
        return new MemoriesReturningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
        controller.revealCards(source, (Cards)cards, game);
        if (MemoriesReturningEffect.putCardInHand(controller, (Cards)cards, source, game)) {
            return true;
        }
        TargetOpponent target = new TargetOpponent();
        target.withNotTarget(true);
        controller.choose(Outcome.Neutral, (Target)target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (MemoriesReturningEffect.putCardOnBottom(controller, opponent, (Cards)cards, source, game)) {
            return true;
        }
        if (MemoriesReturningEffect.putCardInHand(controller, (Cards)cards, source, game)) {
            return true;
        }
        if (MemoriesReturningEffect.putCardOnBottom(controller, opponent, (Cards)cards, source, game)) {
            return true;
        }
        MemoriesReturningEffect.putCardInHand(controller, (Cards)cards, source, game);
        return true;
    }

    private static boolean putCardInHand(Player controller, Cards cards, Ability source, Game game) {
        switch (cards.size()) {
            case 0: {
                return true;
            }
            case 1: {
                controller.moveCards(cards, Zone.HAND, source, game);
                return true;
            }
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        target.withChooseHint("to put in your hand");
        controller.choose(Outcome.DrawCard, cards, (TargetCard)target, source, game);
        controller.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        return false;
    }

    private static boolean putCardOnBottom(Player controller, Player opponent, Cards cards, Ability source, Game game) {
        switch (cards.size()) {
            case 0: {
                return true;
            }
            case 1: {
                controller.putCardsOnBottomOfLibrary(cards, game, source, true);
                return true;
            }
        }
        if (opponent == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        target.withChooseHint("to put on the bottom of " + controller.getName() + "'s library");
        opponent.choose(Outcome.Discard, cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        controller.putCardsOnBottomOfLibrary(card, game, source);
        cards.remove(card);
        return false;
    }
}

