/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class MercadianLiftEffect
extends OneShotEffect {
    MercadianLiftEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "You may put a creature card with mana value X from your hand onto the battlefield";
    }

    private MercadianLiftEffect(MercadianLiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public MercadianLiftEffect copy() {
        return new MercadianLiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            int numberOfCounters = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            FilterCreatureCard filter = new FilterCreatureCard();
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, numberOfCounters));
            filter.setMessage("creature card with mana value " + numberOfCounters);
            TargetCardInHand target = new TargetCardInHand((FilterCard)filter);
            if (target.canChoose(controller.getId(), source, game) && controller.chooseUse(Outcome.PutCardInPlay, "Put " + filter.getMessage() + " from your hand onto the battlefield?", source, game) && controller.choose(Outcome.PutCardInPlay, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
        }
        return false;
    }
}

