/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GreenWhiteElfWarriorToken;

class MercyKillingTokenEffect
extends OneShotEffect {
    MercyKillingTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = ", then creates X 1/1 green and white Elf Warrior creature tokens, where X is that creature's power";
    }

    private MercyKillingTokenEffect(MercyKillingTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public MercyKillingTokenEffect copy() {
        return new MercyKillingTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            int power = permanent.getPower().getValue();
            return new GreenWhiteElfWarriorToken().putOntoBattlefield(power, game, source, permanent.getControllerId());
        }
        return false;
    }
}

