/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class MerenOfClanNelTothEffect
extends OneShotEffect {
    MerenOfClanNelTothEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "choose target creature card in your graveyard. If that card's mana value is less than or equal to the number of experience counters you have, return it to the battlefield. Otherwise, put it into your hand";
    }

    private MerenOfClanNelTothEffect(MerenOfClanNelTothEffect effect) {
        super((OneShotEffect)effect);
    }

    public MerenOfClanNelTothEffect copy() {
        return new MerenOfClanNelTothEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        boolean flag = card.getManaValue() <= player.getCountersCount(CounterType.EXPERIENCE);
        return player.moveCards(card, flag ? Zone.BATTLEFIELD : Zone.HAND, source, game);
    }
}

