/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;

class MesmericFiendLeaveEffect
extends OneShotEffect {
    public MesmericFiendLeaveEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "return the exiled card to its owner's hand";
    }

    private MesmericFiendLeaveEffect(MesmericFiendLeaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public MesmericFiendLeaveEffect copy() {
        return new MesmericFiendLeaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            ExileZone cards;
            int zoneChangeMinusOne = source.getStackMomentSourceZCC() - 1;
            UUID exileId = (UUID)game.getState().getValue(source.getSourceId().toString() + zoneChangeMinusOne);
            if (exileId != null && (cards = game.getExile().getExileZone(exileId)) != null && !cards.isEmpty()) {
                return controller.moveCards((Cards)cards, Zone.HAND, source, game);
            }
        }
        return false;
    }
}

