/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.MetallurgicSummoningsConstructToken;
import mage.game.stack.Spell;

class MetallurgicSummoningsTokenEffect
extends OneShotEffect {
    MetallurgicSummoningsTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create an X/X colorless Construct artifact creature token, where X is that spell's mana value";
    }

    private MetallurgicSummoningsTokenEffect(MetallurgicSummoningsTokenEffect ability) {
        super((OneShotEffect)ability);
    }

    public boolean apply(Game game, Ability source) {
        int mv = Optional.ofNullable((Spell)this.getValue("spellCast")).map(Spell::getManaValue).orElse(0);
        return new MetallurgicSummoningsConstructToken(mv).putOntoBattlefield(1, game, source);
    }

    public MetallurgicSummoningsTokenEffect copy() {
        return new MetallurgicSummoningsTokenEffect(this);
    }
}

