/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;

class MidnightRitualEffect
extends OneShotEffect {
    MidnightRitualEffect() {
        super(Outcome.Neutral);
        this.staticText = "Exile X target creature cards from your graveyard. For each creature card exiled this way, create a 2/2 black Zombie creature token";
    }

    private MidnightRitualEffect(MidnightRitualEffect effect) {
        super((OneShotEffect)effect);
    }

    public MidnightRitualEffect copy() {
        return new MidnightRitualEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cardsToExile = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
            controller.moveCards((Cards)cardsToExile, Zone.EXILED, source, game);
            if (!cardsToExile.isEmpty()) {
                game.processAction();
                new ZombieToken().putOntoBattlefield(cardsToExile.size(), game, source, controller.getId());
            }
            return true;
        }
        return false;
    }
}

