/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.game.permanent.token.Token;

class MillicentRestlessRevenantTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filterNontoken = new FilterControlledPermanent(SubType.SPIRIT);

    MillicentRestlessRevenantTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new SpiritWhiteToken()));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MillicentRestlessRevenantTriggeredAbility(MillicentRestlessRevenantTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MillicentRestlessRevenantTriggeredAbility copy() {
        return new MillicentRestlessRevenantTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        switch (event.getType()) {
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (!zEvent.isDiesEvent()) {
                    return false;
                }
                permanent = zEvent.getTarget();
                break;
            }
            case DAMAGED_PLAYER: {
                if (!((DamagedEvent)event).isCombatDamage()) {
                    return false;
                }
                permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
                break;
            }
            default: {
                return false;
            }
        }
        if (permanent == null) {
            return false;
        }
        return permanent.getId().equals(this.getSourceId()) || filterNontoken.match(permanent, this.getControllerId(), (Ability)this, game);
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
        }
        return super.isInUseableZone(game, sourceObject, event);
    }

    public String getRule() {
        return "Whenever {this} or another nontoken Spirit you control dies or deals combat damage to a player, create a 1/1 white Spirit creature token with flying.";
    }

    static {
        filterNontoken.add((Predicate)TokenPredicate.FALSE);
    }
}

