/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class MimeofactureEffect
extends OneShotEffect {
    MimeofactureEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Choose target permanent an opponent controls. Search that player's library for a card with the same name and put it onto the battlefield under your control. Then that player shuffles.";
    }

    private MimeofactureEffect(MimeofactureEffect effect) {
        super((OneShotEffect)effect);
    }

    public MimeofactureEffect copy() {
        return new MimeofactureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || permanent == null) {
            return false;
        }
        Player opponent = game.getPlayer(permanent.getControllerId());
        if (opponent == null) {
            return false;
        }
        FilterCard filter = new FilterCard("card named " + permanent.getName());
        filter.add((Predicate)new NamePredicate(permanent.getName()));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, filter);
        if (controller.searchLibrary(target, source, game, opponent.getId())) {
            Card card = opponent.getLibrary().getCard(target.getFirstTarget(), game);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        opponent.shuffleLibrary(source, game);
        return true;
    }
}

