/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MimicVatEffect
extends OneShotEffect {
    MimicVatEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile that card";
    }

    private MimicVatEffect(MimicVatEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || permanent == null) {
            return false;
        }
        Card newCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (newCard != null) {
            HashSet<Card> toGraveyard = new HashSet<Card>();
            for (UUID imprintedId : permanent.getImprinted()) {
                Card card = game.getCard(imprintedId);
                if (card == null) continue;
                toGraveyard.add(card);
            }
            controller.moveCards(toGraveyard, Zone.GRAVEYARD, source, game);
            permanent.clearImprinted(game);
            controller.moveCardsToExile(newCard, source, game, true, source.getSourceId(), permanent.getName() + " (Imprint)");
            permanent.imprint(newCard.getId(), game);
        }
        return true;
    }

    public MimicVatEffect copy() {
        return new MimicVatEffect(this);
    }
}

