/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MimicVatEffect;
import mage.constants.AbilityWord;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MimicVatTriggeredAbility
extends TriggeredAbilityImpl {
    MimicVatTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MimicVatEffect(), true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MimicVatTriggeredAbility(MimicVatTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MimicVatTriggeredAbility copy() {
        return new MimicVatTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID sourceCardId = this.getSourceId();
        if (game.getPermanent(sourceCardId) == null && game.getLastKnownInformation(sourceCardId, Zone.BATTLEFIELD) == null) {
            return false;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        Permanent permanent = zEvent.getTarget();
        if (permanent != null && zEvent.isDiesEvent() && !(permanent instanceof PermanentToken) && permanent.isCreature(game)) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return AbilityWord.IMPRINT.formatWord() + "Whenever a nontoken creature dies, you may exile that card. If you do, return each other card exiled with {this} to its owner's graveyard.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

