/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Iterator;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MindExtractionEffect
extends OneShotEffect {
    MindExtractionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player reveals their hand and discards all cards of each of the sacrificed creature's colors.";
    }

    private MindExtractionEffect(MindExtractionEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindExtractionEffect copy() {
        return new MindExtractionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        Permanent sacrificedCreature = null;
        for (Cost cost : source.getCosts()) {
            Permanent permanent;
            SacrificeTargetCost sacCost;
            Iterator iterator;
            if (!(cost instanceof SacrificeTargetCost) || !(iterator = (sacCost = (SacrificeTargetCost)cost).getPermanents().iterator()).hasNext()) continue;
            sacrificedCreature = permanent = (Permanent)iterator.next();
        }
        if (sacrificedCreature == null) {
            return false;
        }
        ObjectColor color = sacrificedCreature.getColor(game);
        CardsImpl cards = new CardsImpl((Collection)player.getHand());
        if (cards.isEmpty()) {
            return true;
        }
        player.revealCards(source, (Cards)cards, game);
        if (color.isColorless()) {
            return true;
        }
        CardsImpl toDiscard = new CardsImpl();
        cards.getCards(game).stream().filter(card -> card.getColor(game).shares(color)).forEach(arg_0 -> ((Cards)toDiscard).add(arg_0));
        player.discard((Cards)toDiscard, false, source, game);
        return true;
    }
}

