/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MindFuneralEffect
extends OneShotEffect {
    MindFuneralEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent reveals cards from the top of their library until four land cards are revealed. That player puts all cards revealed this way into their graveyard";
    }

    private MindFuneralEffect(MindFuneralEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindFuneralEffect copy() {
        return new MindFuneralEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent != null) {
            CardsImpl cards = new CardsImpl();
            int landsFound = 0;
            for (Card card : opponent.getLibrary().getCards(game)) {
                cards.add(card);
                if (!card.isLand(game) || ++landsFound != 4) continue;
                break;
            }
            opponent.revealCards(source, (Cards)cards, game);
            opponent.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            return true;
        }
        return false;
    }
}

