/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class MindSwordsEffect
extends OneShotEffect {
    MindSwordsEffect() {
        super(Outcome.Exile);
        this.staticText = "Each player exiles two cards from their hand.";
    }

    private MindSwordsEffect(MindSwordsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindSwordsEffect copy() {
        return new MindSwordsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        HashMap<UUID, CardsImpl> cardsToExile = new HashMap<UUID, CardsImpl>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            int numberOfCardsToExile = Math.min(2, player.getHand().size());
            CardsImpl cards = new CardsImpl();
            TargetCardInHand target = new TargetCardInHand(numberOfCardsToExile, new FilterCard());
            player.chooseTarget(Outcome.Exile, (Target)target, source, game);
            cards.addAll((Collection)target.getTargets());
            cardsToExile.put(playerId, cards);
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Cards cardsPlayerChoseToExile;
            player = game.getPlayer(playerId);
            if (player == null || (cardsPlayerChoseToExile = (Cards)cardsToExile.get(playerId)) == null) continue;
            player.moveCards(cardsPlayerChoseToExile.getCards(game), Zone.EXILED, source, game);
        }
        return true;
    }
}

