/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MindclawShamanEffect
extends OneShotEffect {
    MindclawShamanEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "target opponent reveals their hand. You may cast an instant or sorcery spell from among those cards without paying its mana cost";
    }

    private MindclawShamanEffect(MindclawShamanEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindclawShamanEffect copy() {
        return new MindclawShamanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)opponent.getHand()), (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
    }
}

