/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MindlinkMechApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class MindlinkMechEffect
extends OneShotEffect {
    MindlinkMechEffect() {
        super(Outcome.Benefit);
        this.setText("until end of turn, {this} becomes a copy of target nonlegendary creature that crewed it this turn, except it's 4/3, it's a Vehicle artifact in addition to its other types, and it has flying.");
    }

    private MindlinkMechEffect(MindlinkMechEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindlinkMechEffect copy() {
        return new MindlinkMechEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || creature == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, creature, permanent.getId(), source, (CopyApplier)new MindlinkMechApplier());
        return true;
    }
}

