/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MindreaverExileEffect
extends OneShotEffect {
    MindreaverExileEffect() {
        super(Outcome.Exile);
        this.staticText = "exile the top three cards of target player's library";
    }

    private MindreaverExileEffect(MindreaverExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public MindreaverExileEffect copy() {
        return new MindreaverExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        return controller.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

