/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;

public final class MinotaurTactician
extends CardImpl {
    private static final FilterControlledCreaturePermanent filterWhite = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterBlue = new FilterControlledCreaturePermanent();
    private static final String ruleWhite = "{this} gets +1/+1 as long as you control a white creature";
    private static final String ruleBlue = "{this} gets +1/+1 as long as you control a blue creature";

    public MinotaurTactician(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{R}");
        this.subtype.add((Object)SubType.MINOTAUR);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)HasteAbility.getInstance());
        PermanentsOnTheBattlefieldCondition conditionWhite = new PermanentsOnTheBattlefieldCondition((FilterPermanent)filterWhite);
        ConditionalContinuousEffect effectWhite = new ConditionalContinuousEffect((ContinuousEffect)new BoostSourceEffect(1, 1, Duration.WhileOnBattlefield), (Condition)conditionWhite, ruleWhite);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effectWhite));
        PermanentsOnTheBattlefieldCondition conditionBlue = new PermanentsOnTheBattlefieldCondition((FilterPermanent)filterBlue);
        ConditionalContinuousEffect effectBlue = new ConditionalContinuousEffect((ContinuousEffect)new BoostSourceEffect(1, 1, Duration.WhileOnBattlefield), (Condition)conditionBlue, ruleBlue);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effectBlue));
    }

    private MinotaurTactician(MinotaurTactician card) {
        super((CardImpl)card);
    }

    public MinotaurTactician copy() {
        return new MinotaurTactician(this);
    }

    static {
        filterWhite.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
        filterBlue.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
    }
}

