/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.keyword.SoulbondAbility;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MiragePhalanxEffect
extends OneShotEffect {
    MiragePhalanxEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of this creature, except it has haste and loses soulbond. Exile it at end of combat.";
    }

    private MiragePhalanxEffect(MiragePhalanxEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect tokenCopyEffect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true);
        tokenCopyEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        tokenCopyEffect.addAbilityClassesToRemoveFromTokens(SoulbondAbility.class);
        tokenCopyEffect.apply(game, source);
        tokenCopyEffect.removeTokensCreatedAt(game, source, true, PhaseStep.END_COMBAT, TargetController.ANY);
        return !tokenCopyEffect.getAddedPermanents().isEmpty();
    }

    public MiragePhalanxEffect copy() {
        return new MiragePhalanxEffect(this);
    }
}

