/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MirariTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterSpell filter = new FilterSpell();

    MirariTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new CopyTargetStackObjectEffect(true), (Cost)new GenericManaCost(3)), false);
    }

    private MirariTriggeredAbility(MirariTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MirariTriggeredAbility copy() {
        return new MirariTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getPlayerId().equals(this.getControllerId()) && this.isControlledInstantOrSorcery(spell = game.getStack().getSpell(event.getTargetId()), game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
            return true;
        }
        return false;
    }

    private boolean isControlledInstantOrSorcery(Spell spell, Game game) {
        return spell != null && spell.isControlledBy(this.getControllerId()) && spell.isInstantOrSorcery(game);
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell, you may pay {3}. If you do, copy that spell. You may choose new targets for the copy.";
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.INSTANT.getPredicate(), (Predicate)CardType.SORCERY.getPredicate()));
    }
}

