/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MirkwoodElkEffect
extends OneShotEffect {
    MirkwoodElkEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target Elf card from your graveyard to your hand. You gain life equal to that card's power.";
    }

    private MirkwoodElkEffect(MirkwoodElkEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirkwoodElkEffect copy() {
        return new MirkwoodElkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card targetElf = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (targetElf != null) {
                controller.moveCards(targetElf, Zone.HAND, source, game);
                controller.gainLife(targetElf.getPower().getValue(), game, source);
            }
            return true;
        }
        return false;
    }
}

