/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.m.MirrorOfFateTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class MirrorOfFateEffect
extends OneShotEffect {
    MirrorOfFateEffect() {
        super(Outcome.Neutral);
        this.staticText = "Choose up to seven face-up exiled cards you own. Exile all the cards from your library, then put the chosen cards on top of your library";
    }

    private MirrorOfFateEffect(MirrorOfFateEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorOfFateEffect copy() {
        return new MirrorOfFateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        MirrorOfFateTarget targetExile = new MirrorOfFateTarget();
        if (controller.choose(this.outcome, (Target)targetExile, source, game)) {
            cards.addAll((Collection)targetExile.getTargets());
        }
        controller.moveCards((Cards)new CardsImpl((Collection)controller.getLibrary().getCardList()), Zone.EXILED, source, game);
        return controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
    }
}

