/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeSourceEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class MirrorOfTheForebearsCopyEffect
extends OneShotEffect {
    MirrorOfTheForebearsCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "until end of turn, {this} becomes a copy of target creature you control of the chosen type, except it's an artifact in addition to its other types";
    }

    private MirrorOfTheForebearsCopyEffect(MirrorOfTheForebearsCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MirrorOfTheForebearsCopyEffect copy() {
        return new MirrorOfTheForebearsCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            game.copyPermanent(Duration.EndOfTurn, copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            game.addEffect((ContinuousEffect)new AddCardTypeSourceEffect(Duration.EndOfTurn, new CardType[]{CardType.ARTIFACT}), source);
            return true;
        }
        return false;
    }
}

