/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.BlocksOrBlockedByCreatureSourceTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.EquipAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;

public final class MirrorShield
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature with deathtouch");
    private static final String triggerPhrase = "Whenever a creature with deathtouch blocks or becomes blocked by this creature, ";

    public MirrorShield(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");
        this.subtype.add((Object)SubType.EQUIPMENT);
        TriggeredAbilityImpl gainedAbility = new BlocksOrBlockedByCreatureSourceTriggeredAbility((Effect)new DestroyTargetEffect(), filter).setTriggerPhrase(triggerPhrase);
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostEquippedEffect(0, 2));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)HexproofAbility.getInstance(), AttachmentType.EQUIPMENT).setText("and has hexproof"));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)gainedAbility, AttachmentType.EQUIPMENT).setText("and \"Whenever a creature with deathtouch blocks or becomes blocked by this creature, destroy that creature.\""));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new EquipAbility(2));
    }

    private MirrorShield(MirrorShield card) {
        super((CardImpl)card);
    }

    public MirrorShield copy() {
        return new MirrorShield(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(DeathtouchAbility.class));
    }
}

