/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MirrorStrikeEffect
extends ReplacementEffectImpl {
    MirrorStrikeEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.staticText = "All combat damage that would be dealt to you this turn by target unblocked creature is dealt to its controller instead";
    }

    private MirrorStrikeEffect(MirrorStrikeEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MirrorStrikeEffect copy() {
        return new MirrorStrikeEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player targetsController;
        Permanent targetPermanent;
        Player controller = game.getPlayer(source.getControllerId());
        DamageEvent damageEvent = (DamageEvent)event;
        if (controller != null && (targetPermanent = game.getPermanent(source.getFirstTarget())) != null && (targetsController = game.getPlayer(targetPermanent.getControllerId())) != null) {
            targetsController.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
            return true;
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        DamageEvent damageEvent = (DamageEvent)event;
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (controller != null && targetPermanent != null) {
            return damageEvent.isCombatDamage() && Objects.equals(controller.getId(), damageEvent.getTargetId()) && Objects.equals(targetPermanent.getId(), damageEvent.getSourceId());
        }
        return false;
    }
}

