/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.m.MirroredLotusAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MirroredLotusReplacementEffect
extends ReplacementEffectImpl {
    MirroredLotusReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "Reflect {0} <i>(As this enters the battlefield, each opponent may pay {0}. When they do, they create a token copy of this except it lacks this ability.)</i>";
    }

    private MirroredLotusReplacementEffect(MirroredLotusReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MirroredLotusReplacementEffect copy() {
        return new MirroredLotusReplacementEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Set opponentsIds = game.getOpponents(source.getControllerId());
        for (UUID playerId : game.getPlayerList()) {
            ManaCostsImpl cost;
            Player opponent;
            if (!opponentsIds.contains(playerId) || (opponent = game.getPlayer(playerId)) == null || !(cost = new ManaCostsImpl("{0}")).canPay(source, source, playerId, game) || !opponent.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + " for Reflect?", source, game) || !cost.pay(source, game, source, playerId, false)) continue;
            game.informPlayers(opponent.getLogName() + " paid the Reflect cost");
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(playerId);
            effect.addAbilityClassesToRemoveFromTokens(MirroredLotusAbility.class);
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
            ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)effect, false, "create a token copy of {this} except it lacks the Reflect ability");
            reflexive.setControllerId(playerId);
            game.fireReflexiveTriggeredAbility(reflexive, source);
        }
        return false;
    }
}

