/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MiseEffect
extends OneShotEffect {
    MiseEffect() {
        super(Outcome.Detriment);
        this.staticText = ", then reveal the top card of your library. If that card has the chosen name, you draw three cards";
    }

    private MiseEffect(MiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (player != null && cardName != null) {
            Card card = player.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            if (card != null) {
                player.revealCards("Mise", (Cards)cards, game, true);
                if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
                    player.drawCards(3, source, game);
                }
            }
            return true;
        }
        return false;
    }

    public MiseEffect copy() {
        return new MiseEffect(this);
    }
}

