/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MishrasCommandEffect
extends OneShotEffect {
    MishrasCommandEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target player. They may discard up to X cards. Then they draw a card for each card discarded this way";
    }

    private MishrasCommandEffect(MishrasCommandEffect effect) {
        super((OneShotEffect)effect);
    }

    public MishrasCommandEffect copy() {
        return new MishrasCommandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player != null && xValue > 0) {
            player.drawCards(player.discard(0, xValue, false, source, game).size(), source, game);
            return true;
        }
        return false;
    }
}

