/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class MistOfStagnationEffect
extends OneShotEffect {
    MistOfStagnationEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player chooses a permanent for each card in their graveyard, then untaps those permanents";
    }

    private MistOfStagnationEffect(MistOfStagnationEffect effect) {
        super((OneShotEffect)effect);
    }

    public MistOfStagnationEffect copy() {
        return new MistOfStagnationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        if (activePlayer != null) {
            int cardsInGrave = activePlayer.getGraveyard().size();
            if (cardsInGrave > 0) {
                TargetPermanent target = new TargetPermanent(cardsInGrave, cardsInGrave, new FilterPermanent("permanents to untap"), true);
                activePlayer.chooseTarget(this.outcome, (Target)target, source, game);
                for (UUID oneTarget : target.getTargets()) {
                    Permanent p = game.getPermanent(oneTarget);
                    if (p == null) continue;
                    p.untap(game);
                }
            }
            return true;
        }
        return false;
    }
}

