/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MistsOfLorienEffect
extends OneShotEffect {
    MistsOfLorienEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target nonland permanent and each other nonland permanent with the same mana value as that permanent to their owners' hands.";
    }

    private MistsOfLorienEffect(MistsOfLorienEffect effect) {
        super((OneShotEffect)effect);
    }

    public MistsOfLorienEffect copy() {
        return new MistsOfLorienEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller != null && permanent != null) {
            FilterNonlandPermanent filter = new FilterNonlandPermanent();
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, permanent.getManaValue()));
            CardsImpl cardsToHand = new CardsImpl();
            for (Permanent perm : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                cardsToHand.add((Card)perm);
            }
            controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

