/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MistveilPlainsGraveyardToLibraryEffect
extends OneShotEffect {
    MistveilPlainsGraveyardToLibraryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put target card from your graveyard on the bottom of your library";
    }

    private MistveilPlainsGraveyardToLibraryEffect(MistveilPlainsGraveyardToLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public MistveilPlainsGraveyardToLibraryEffect copy() {
        return new MistveilPlainsGraveyardToLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (card == null || player == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        return player.putCardsOnBottomOfLibrary(card, game, source);
    }
}

