/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.m.MnemonicBetrayalReturnEffect;
import mage.game.Game;
import mage.game.events.GameEvent;

class MnemonicBetrayalDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    public MnemonicBetrayalDelayedTriggeredAbility(Set<MageObjectReference> morSet) {
        super((Effect)new MnemonicBetrayalReturnEffect(morSet));
        this.triggerOnlyOnce = true;
        this.morSet.addAll(morSet);
    }

    private MnemonicBetrayalDelayedTriggeredAbility(MnemonicBetrayalDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.morSet.addAll(ability.morSet);
    }

    public MnemonicBetrayalDelayedTriggeredAbility copy() {
        return new MnemonicBetrayalDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return true;
    }

    public boolean checkInterveningIfClause(Game game) {
        return this.morSet.stream().map(mor -> mor.getCard(game)).anyMatch(Objects::nonNull);
    }

    public String getRule() {
        return "At the beginning of the next end step, if any of those cards remain exiled, return them to their owner's graveyards.";
    }
}

