/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import org.apache.log4j.Logger;

class MnemonicDelugeEffect
extends OneShotEffect {
    MnemonicDelugeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target instant or sorcery card from a graveyard. Copy that card three times. You may cast the copies without paying their mana costs.";
    }

    private MnemonicDelugeEffect(MnemonicDelugeEffect effect) {
        super((OneShotEffect)effect);
    }

    public MnemonicDelugeEffect copy() {
        return new MnemonicDelugeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardsImpl cards = new CardsImpl();
        for (int i = 0; i < 3; ++i) {
            Card copiedCard = game.copyCard(card, source, source.getControllerId());
            cards.add(copiedCard);
        }
        for (Card copiedCard : cards.getCards(game)) {
            if (!player.chooseUse(this.outcome, "Cast the copied card?", source, game)) continue;
            if (copiedCard.getSpellAbility() != null) {
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                player.cast(player.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
                continue;
            }
            Logger.getLogger(MnemonicDelugeEffect.class).error((Object)("Mnemonic Deluge: spell ability == null " + copiedCard.getName()));
        }
        return true;
    }
}

