/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.AttackingCreatureCount;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MobMentalityTriggeredAbility
extends TriggeredAbilityImpl {
    MobMentalityTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostTargetEffect((DynamicValue)new AttackingCreatureCount(), (DynamicValue)StaticValue.get((int)0), Duration.EndOfTurn));
    }

    private MobMentalityTriggeredAbility(MobMentalityTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MobMentalityTriggeredAbility copy() {
        return new MobMentalityTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackingPlayerId().equals(this.getControllerId())) {
            return false;
        }
        Permanent aura = game.getPermanent(this.getSourceId());
        if (aura == null) {
            return false;
        }
        Permanent creature = game.getPermanent(aura.getAttachedTo());
        if (creature == null) {
            return false;
        }
        for (Effect effect : this.getEffects()) {
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(this.getControllerId())) {
            if (!permanent.isCreature(game) || permanent.hasSubtype(SubType.WALL, game) || permanent.isAttacking()) continue;
            return false;
        }
        return true;
    }

    public String getRule() {
        return "Whenever all non-Wall creatures you control attack, enchanted creature gets +X/+0 until end of turn, where X is the number of attacking creatures.";
    }
}

