/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.choices.VoteHandler;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class MobVerdictVote
extends VoteHandler<Player> {
    private static final FilterPlayer filter = new FilterPlayer("another player");

    MobVerdictVote() {
        this.secret = true;
    }

    protected Set<Player> getPossibleVotes(Ability source, Game game) {
        return game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected Player playerChoose(String voteInfo, Player player, Player decidingPlayer, Ability source, Game game) {
        TargetPlayer target = new TargetPlayer(filter);
        target.withNotTarget(true);
        target.withChooseHint("to vote for");
        decidingPlayer.choose(Outcome.Benefit, (Target)target, source, game);
        return game.getPlayer(target.getFirstTarget());
    }

    protected String voteName(Player vote) {
        return vote.getName();
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getPlayerPredicate());
    }
}

